define(['angular', 'app', 'TrackersFHIRService'], function (angular, app) {
    'use strict';

    app.service('MoodFHIRService', function (TrackersFHIRService) {
        var emptyMoodResource = {
            meta: {
                tag: [
                    {
                        'system': 'https://wiki.mobilehealth.DOMAIN.EXT/display/PGDMS/Client+Provenance+Mapping',
                        'code': 'REDACTED',
                        'display': 'VA FitHeart'
                    }
                ]
            },
            code: {coding: [{system: 'http://loinc.org', code: '52497-5', display: 'Mood'}]},
            valueQuantity: {
                unit: 'rating'
            }
        };

        return angular.extend({}, angular.copy(TrackersFHIRService), {
            code: 'http://loinc.org|52497-5',
            supportsLatest: true,

            createEmpty: function () {
                var emptyResource = angular.copy(emptyMoodResource);

                return angular.extend({}, TrackersFHIRService.createEmpty(), emptyResource);
            }
        });
    });
});